
/****** Object:  StoredProcedure [dbo].[P_EST_PROD_CPL_CUSTO_REPLICA]    Script Date: 02/15/2013 19:10:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_CUSTO_REPLICA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_CUSTO_REPLICA]
GO
--EXECUTE P_EST_PROD_CPL_CUSTO_REPLICA 93,93,1,1
CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_CUSTO_REPLICA](@CD_FILIAL_ORIG INT, 
													  @CD_FILIAL_DEST INT,
													  @FLAG_SUBST INT,
													  @CD_USU INT) AS 
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_PROD INT
DECLARE @VLR_CUSTO_MEDIO MONEY
DECLARE @DT_PROC DATETIME
SET NOCOUNT ON 

CREATE TABLE #RS_PROD_ORIG (CD_EMP INT, 
							 CD_FILIAL INT, 
							 CD_PROD INT, 
							 VLR_PRECO_CUSTO_MD MONEY)
IF @FLAG_SUBST <> 2
begin
	INSERT INTO #RS_PROD_ORIG
	SELECT 
		EST_PROD_CPL.CD_EMP,
		@CD_FILIAL_DEST,
		EST_PROD_CPL.CD_PROD,
		CASE WHEN ISNULL(EST_PROD_CPL.VLR_CUSTO_MD,0) = 0 THEN EST_PROD_CPL.VLR_CUSTO ELSE EST_PROD_CPL.VLR_CUSTO_MD END
		
	FROM
		EST_PROD_CPL INNER JOIN EST_PROD ON
		EST_PROD_CPL.CD_EMP = EST_PROD.CD_EMP AND
		EST_PROD_CPL.CD_PROD = EST_PROD.CD_PROD
	WHERE
		EST_PROD_CPL.CD_EMP = 1
		AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL_ORIG
		AND (EST_PROD_CPL.VLR_CUSTO + EST_PROD_CPL.VLR_CUSTO_MD) > 0
end

IF @FLAG_SUBST = 2
begin
	INSERT INTO #RS_PROD_ORIG
	SELECT 
		EST_PROD_CPL.CD_EMP,
		@CD_FILIAL_DEST,
		EST_PROD_CPL.CD_PROD,
		dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (EST_PROD_CPL.CD_EMP,EST_PROD_CPL.CD_FILIAL,EST_PROD_CPL.CD_PROD,CONVERT(CHAR(10),GETDATE(),112),3)
	FROM
		EST_PROD_CPL INNER JOIN EST_PROD ON
		EST_PROD_CPL.CD_EMP = EST_PROD.CD_EMP AND
		EST_PROD_CPL.CD_PROD = EST_PROD.CD_PROD
	WHERE
		EST_PROD_CPL.CD_EMP = 1
		AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL_DEST
end

IF @FLAG_SUBST= 0 
begin
	DECLARE cProdutoFilialNovo CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT
		r.CD_EMP,
		r.CD_FILIAL,
		r.CD_PROD,
		CONVERT(CHAR(10),GETDATE(),112),
		r.VLR_PRECO_CUSTO_MD
	FROM
		#RS_PROD_ORIG r INNER JOIN EST_PROD_CPL c ON
		r.CD_EMP = c.CD_EMP AND
		r.CD_FILIAL = c.CD_FILIAL AND
		r.CD_PROD = c.CD_PROD AND
		c.VLR_CUSTO  = 0
end

IF @FLAG_SUBST = 1 OR @FLAG_SUBST = 2
begin
	DECLARE cProdutoFilialNovo CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT
		r.CD_EMP,
		r.CD_FILIAL,
		r.CD_PROD,
		CONVERT(CHAR(10),GETDATE(),112),
		r.VLR_PRECO_CUSTO_MD
	FROM
		#RS_PROD_ORIG r INNER JOIN EST_PROD_CPL c ON
		r.CD_EMP = c.CD_EMP AND
		r.CD_FILIAL = c.CD_FILIAL AND
		r.CD_PROD = c.CD_PROD
end

	OPEN cProdutoFilialNovo
	FETCH NEXT FROM cProdutoFilialNovo INTO @CD_EMP,@CD_FILIAL,@CD_PROD,@DT_PROC,@VLR_CUSTO_MEDIO
	WHILE @@FETCH_STATUS=0
	BEGIN
		BEGIN TRY
				PRINT 'Filial.: ' + CONVERT(VARCHAR, @CD_FILIAL) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
				EXEC P_EST_PROD_CPL_CUSTO_NOVO_LANCAMENTO @CD_EMP,@CD_FILIAL,@CD_PROD,@DT_PROC, @VLR_CUSTO_MEDIO,@CD_USU;
		END TRY
		BEGIN CATCH
			PRINT 'Filial.: ' + CONVERT(VARCHAR, @CD_FILIAL) + ' ' +   CONVERT(VARCHAR, GETDATE (),108)
			PRINT ERROR_MESSAGE() 
		END CATCH

		FETCH NEXT FROM cProdutoFilialNovo INTO @CD_EMP,@CD_FILIAL,@CD_PROD,@DT_PROC,@VLR_CUSTO_MEDIO
	END
CLOSE cProdutoFilialNovo
DEALLOCATE cProdutoFilialNovo